/* ************************************************************************** */
/* Example of a syndication feed reader using the Project Rome API            */
/* current version of Rome: rome1.0.jar            https://rome.dev.java.net/ */
/* You need to implement this API plus the JDOM API                           */
/* jdom.jar  ,   you can find this at               https://jdom.org/         */
/* Parts of this example are taken from the PRome Web Page tutorials          */
/* https://rome.dev.java.net/ thanks to author:   Alejandro Abdelnur          */
/*                                                                            */
/* Prints a retrieved feed in its pure and tree format to the system and      */
/* saves to files, one in the retrieved format and one in the converted format*/
/* created by Martin Stoppacher       date:  26.12.2009                       */
/* license:    LGPL 3.0                                                       */
/*             (Lesser Gnu Public License version 3.0),                       */
/*             cf. <http://www.gnu.org/licenses/lgpl.html>                    */
/* ************************************************************************** */
import java.net.URL;
/*  Class URL represents a Uniform Resource Locator,                          */
/*  a pointer to a "resource" on the World Wide Web                           */
import java.io.FileWriter;
/*class for writing character files*/
import java.io.InputStreamReader;
/*  An InputStreamReader is a bridge from byte streams to character streams   */
import java.io.PrintWriter;
/* Print formatted representations of objects to a text-output stream         */
import java.io.Writer;
/* Abstract class for writing to character streams                            */
import com.sun.syndication.feed.synd.SyndFeed;
/* This is the Bean interface for all types of feeds.                         */
import com.sun.syndication.io.SyndFeedInput;
/* Parses an XML document (File, InputStream, Reader, W3C SAX InputSource, W3C*/
/* DOM Document or JDom DOcument) into an WireFeed (RSS/Atom).                */
import com.sun.syndication.io.SyndFeedOutput;
/* Generates an XML document(String, File, OutputStream, Writer,              */
/* W3C DOM document or JDOM document)out of an SyndFeedImpl                   */
import com.sun.syndication.io.XmlReader;
/* Character stream that handles (or at least attemtps to) all the necessary  */
/* Voodo to figure out the charset encoding of the XML document within        */
/* the stream.                                                                */

public class 4_FeedReader_Combination {

    public static void main(String[] args) {
        boolean ok = false;
            try {
                String feedType = "http://rss.orf.at/fm4.xml";
    	          String outputType = "rss_2.0";
    	          String fileName = "test2_file_with_specified_output";
    	          String fileName2 = "test3_original_source_file";
            	  //String feedType = args[0];   /*creates a string with the URL*/
                //String fileName = args[1]; 
                /*                creates a string with the filename to write */
                URL feedUrl = new URL(feedType);

                SyndFeedInput input = new SyndFeedInput();/* new input object */
                SyndFeed feed = input.build(new XmlReader(feedUrl));
                /*                   reads feed from URL and puts it into feed*/
                feed.setFeedType(outputType);
                
                Writer writer = new FileWriter(fileName); /* new writer object*/
                SyndFeedOutput output = new SyndFeedOutput();
                /*                                           new output object*/
                output.output(feed,writer);
                /*                          outout method, writes feed to file*/
                writer.close();
                
                SyndFeedInput input2 = new SyndFeedInput(); /*new input object*/
                SyndFeed feed2 = input2.build(new XmlReader(feedUrl));
                /*                   reads feed from URL and puts it into feed*/
                
                
                Writer writer2 = new FileWriter(fileName2);
                /*                                        second writer object*/
                SyndFeedOutput output2 = new SyndFeedOutput();
                /*                                        second output object*/
                output2.output(feed2,writer2);
                /*                   second outout method, writes feed to file*/
                writer.close();
                
                System.out.println("The feed output with the 
                                   +" Print Writer Class");
                System.out.println("___________");
                output.output(feed,new PrintWriter(System.out));
                
                System.out.println("The feed outputed by the system");
                System.out.println("___________");
                System.out.println(feed);             /*outputs file to system*/
                System.out.println("___________");
                System.out.println("The feed has been written 
                                  +" to the file ["+fileName+"]");
                System.out.println("The feed has been written 
                                  +" to the file ["+fileName2+"]");
                ok = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("ERROR: "+ex.getMessage());
            }

        if (!ok) {
            System.out.println();
            System.out.println("FeedReader reads and prints any 
                              +" RSS/Atom feed type.");
            System.out.println("The first parameter must be the 
                              +" URL of the feed to read.");
            System.out.println();
        }
  
}
}